<?php

/**

 * @package Display WooCommerce Shop on your Facebook Page

 * @version 1.0.6

 */

/*

 Plugin Name:  Display WooCommerce Shop on your Facebook Page

 Plugin URI: http://appsmav.com

 Description: Display your WooCommerce store on your Facebook page. Automatic import. No coding. 10 products listed FREE FOREVER.

 Version: 1.0.6

 Author: Appsmav

 Author URI: http://appsmav.com

 License: GPL2

*/

/*  Copyright 2015  Appsmav  (email : support@appsmav.com)



    This program is free software; you can redistribute it and/or modify

    it under the terms of the GNU General Public License, version 2, as 

    published by the Free Software Foundation.



    This program is distributed in the hope that it will be useful,

    but WITHOUT ANY WARRANTY; without even the implied warranty of

    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

    GNU General Public License for more details.



    You should have received a copy of the GNU General Public License

    along with this program; if not, write to the Free Software

    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );



if(!class_exists('Fshop_appsmav'))

{

    class Fshop_appsmav 

    {

		protected static $_domain 		= 'https://appsmav.com/';

		protected static $_login_url 	= 'https://appsmav.com/login/index/';

		protected static $_curl_url     = 'http://appsmav.com/handle_curl.php';

        /**

         * Construct the plugin object

         */

        public function __construct()

        {

            // register actions

			add_action('admin_init', array(&$this, 'admin_init'));

			add_action('admin_menu', array(&$this, 'add_menu'));

			add_action('admin_enqueue_scripts', array(&$this,'google_font_styles'));

			add_action('parse_request', array(&$this,'fshop_create_rss_product'));	

					

        } // END public function __construct

    

        /**

         * Activate the plugin

         */

        public static function activate()

        {

            // Do nothing

			update_option( 'fshop_apps_register', 2 );

			$email	=	get_option('fshop_admin_email',0);

			

			if($email	===	0){

				$email	=	get_bloginfo('admin_email');

				update_option('fshop_admin_email',$email);

			}

        } // END public static function activate

    

        /**

         * Deactivate the plugin

         */     

        public static function deactivate()

        {

			$to = 'developers@appsmav.com';

			$subject = 'Fshop plugin deactivated';

			$body = '<p>Plugin is deactivated . Info below</p>';

			$body .= '<p>Site Url : '.get_option('siteurl').'</p>';

			$body .= '<p>Admin Email : '.get_option('fshop_admin_email').'</p>';

			$body .= '<p>App Id : '.get_option('fshop_apps_id').'</p>';

			$body .= '<p>Service Id : '.get_option('fshop_apps_appid').'</p>';

			$headers = array('Content-Type: text/html; charset=UTF-8');

			

			delete_option('fshop_admin_email');

			delete_option('fshop_apps_id');

			delete_option('fshop_apps_pageid');

			delete_option('fshop_apps_pageurl');

			delete_option('fshop_apps_appid');

			delete_option('fshop_apps_payload');

					 

			wp_mail( $to, $subject, $body, $headers );	

									

        } // END public static function deactivate

		

		/**

		 * hook into WP's admin_init action hook

		 */

		public function admin_init()

		{

			// Set up the settings for this plugin

			$this->init_settings();

			// Possibly do additional admin_init tasks

		} // END public static function activate

				

		/**

		 * Initialize some custom settings

		 */     

		public function init_settings()

		{						

			add_action( 'wp_ajax_fscreate_account', array(&$this,'fs_ajax_fscreate_account' ));

			add_action( 'wp_ajax_fscheck_settings', array(&$this,'fs_ajax_fscheck_settings' ));

			

		} // END public function init_custom_settings()

		

				

		/**

		 * add a menu

		 */     

		public function add_menu()

		{

			add_options_page('Fshop Appsmav Settings', 'Facebook Shop Appsmav', 'manage_options', 'fshopappsmav', array(&$this, 'plugin_settings_page'));

		} // END public function add_menu()



		/**

		 * Additional Styles

		 * @since 1.0.0

		 */



		public function google_font_styles($hook) {

				if('settings_page_fshopappsmav' != $hook)

					return;

				

				// register styles

				wp_register_style('googlefont-montserrat', 'https://fonts.googleapis.com/css?family=Montserrat:400,700|Open+Sans:400,300,600,700', array(), false, 'all');

				wp_register_style( 'fshop_appsmav_css', plugins_url('/css/fshop.css', __FILE__) );

				wp_register_style( 'jquery_validity_css', plugins_url('/css/jquery.validity.css', __FILE__) );

				wp_register_style( 'bootstrap_css', plugins_url('/css/bootstrap-3.2.0.min.css', __FILE__) );

				// enqueue styles	

				

				wp_enqueue_style('googlefont-montserrat');

				wp_enqueue_style('fshop_appsmav_css');

				wp_enqueue_style('jquery_validity_css');

				wp_enqueue_style('bootstrap_css');

				

				

				wp_enqueue_script( 'bootstrap_script', plugins_url( '/js/bootstrap.min.js',__FILE__ ),array(), '1.0.1', true );

				wp_enqueue_script( 'jquery_validity_script', plugins_url( '/js/jquery.validity.js',__FILE__ ),array(), '1.0.1', true );

				wp_enqueue_script( 'fshop_appsmav_script', plugins_url( '/js/fshop.js',__FILE__ ),array(), '1.0.1', true );

		}

		

		/**

		 * Menu Callback

		 */     

		public function plugin_settings_page()

		{

			if(!current_user_can('manage_options'))

				wp_die(__('You do not have sufficient permissions to access this page.'));

			



			// Render the settings template

			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {	

				$login_url	='';

				if(get_option('fshop_apps_register', 0 )	== 1){

					$arr['id_apps']		=	get_option('fshop_apps_id', 0 );

					$arr['id_site']		=	get_option('fshop_apps_appid', 0 );

					

					$arr['admin_email']	=	get_option('fshop_admin_email');

					$arr['payload']		=	get_option('fshop_apps_payload', 0 );

					

					if(get_option('fshop_apps_pageurl', 0 )	!==	0)		

						$login_url	=	get_option('fshop_apps_pageurl');

					else

					$login_url	=	self::$_login_url.'autologin?id_apps='.$arr['id_apps'].'&id_site='.$arr['id_site'].'&admin_email='.$arr['admin_email'].'&payload='.$arr['payload'].'&w_rss='.urlencode(home_url("/index.php?fsawoo=woo_fshop_rss")).'&w_api='.urlencode(home_url("/index.php?fsawoo=woo_fshop_api")).'&w_plg=woo_shop';

				 }

				 

				include(sprintf("%s/templates/settings.php", dirname(__FILE__)));

			 }

			else

			{

				echo "<h2>Please Activate Woocommerce Plugin to add settings<h2>";

			}



		} // END public function plugin_settings_page()

		

		private function get_the_post_thumbnail_src( $post_id = null, $size = 'post-thumbnail' ) {



			$post_thumbnail_id = get_post_thumbnail_id( $post_id );



			if ( ! $post_thumbnail_id ) {

				return false;

			}



			list( $src ) = wp_get_attachment_image_src( $post_thumbnail_id, $size, false );



			return $src;

		}

	

		private function cut_sense($descp, $l_descp) {

			$descp = strip_tags($descp);

			if ( strlen($descp) > $l_descp){

				$end='...';

			}else{

				$end='';

			}

			if ( function_exists('mb_strcut') ){

				$descp = mb_strcut ( $descp, 0 , $l_descp , "UTF-8" );

			}else{

				$descp =substr($descp, 0, $l_descp);

			}

			$text=''.$descp.''.$end.'';

			return $text;			

		}

		

		public function fshop_create_rss_product(){

			if ( !is_admin() ) {

				if (isset ( $_REQUEST['fsawoo'] )) {

					switch ($_REQUEST['fsawoo']){

						 case 'woo_fshop_api':

							$id_page	=	$_POST['id_page'];

							$url_page	=	$_POST['url_page'];

							update_option( 'fshop_apps_pageid', $id_page);

							update_option( 'fshop_apps_pageurl', $url_page);

							

							$arr['error']	=	0;

							$arr['msg']		=	'success';

							die(json_encode($arr));

						break;

						case 'woo_fshop_rss':

							$args['post_type'] = 'product';

							$args['numberposts'] = '999';

							$args['offset'] = 0;



							if(isset($_GET['catAll']))

							{

								header("Content-Type: application/xml; charset=UTF-8");

				

								echo "<?xml version='1.0' encoding='UTF-8' ?>\n\r";

								echo "<rss version='2.0' xmlns:atom='http://www.w3.org/2005/Atom' >\n";

								echo "  <channel>\n";

								echo "    <title><![CDATA[".get_option('blogname')." Products]]></title>\n";

								echo "    <link>".get_option('siteurl')."</link>\n";

								echo "    <description>Social Facebook Shop Feed By Appsmav</description>\n";

							

								 $taxonomy     = 'product_cat';

								 $orderby      = 'name';  

								 $show_count   = 0;      // 1 for yes, 0 for no

								 $pad_counts   = 0;      // 1 for yes, 0 for no

								 $hierarchical = 1;      // 1 for yes, 0 for no  

								 $title        = '';  

								 $empty        = 0;



								 $args = array(

										 'taxonomy'     => $taxonomy,

										 'orderby'      => $orderby,

										 'show_count'   => $show_count,

										 'pad_counts'   => $pad_counts,

										 'hierarchical' => $hierarchical,

										 'title_li'     => $title,

										 'hide_empty'   => $empty

								  );

								$all_categories = get_categories( $args );

								foreach ($all_categories as $cat) {

									if($cat->category_parent == 0) {

										echo "    <item>\n\r";

										echo "      <title><![CDATA[".$cat->name."]]></title>\n\r";

										echo "      <link><![CDATA[".get_term_link($cat->slug, 'product_cat')."]]></link>\n\r";

										echo "      <categoryname><![CDATA[".$cat->name."]]></categoryname>\n\r";

										echo "      <categoryid><![CDATA[".$cat->term_id."]]></categoryid>\n\r";

									echo "    </item>\n\r";

									}								

								}

								echo "  </channel>\n\r";

								echo "</rss>";



								exit();

							}

							

							$products = get_posts ($args);

							

							$currency = get_option ( 'woocommerce_currency' );

							

							header("Content-Type: application/xml; charset=UTF-8");

				

							echo "<?xml version='1.0' encoding='UTF-8' ?>\n\r";

							echo "<rss version='2.0' xmlns:atom='http://www.w3.org/2005/Atom' >\n";

							echo "  <channel>\n";

							echo "    <title><![CDATA[".get_option('blogname')." Products]]></title>\n";

							echo "    <link>".get_option('siteurl')."</link>\n";

							echo "    <description>Social Facebook Shop Feed By Appsmav</description>\n";

				

							foreach ($products as $post) {



								setup_postdata($post);



								if (function_exists('get_product')) {

									$woocommerce_product = get_product ( $post->ID );

								} else {

									$woocommerce_product = new woocommerce_product ( $post->ID );

								}



								if ( $woocommerce_product->visibility == 'hidden' )

									continue;

									

								if ( ! $woocommerce_product->is_in_stock() )

									continue;

									

								$price_exclude_tax = $woocommerce_product->get_price_excluding_tax();

								$org_price = $woocommerce_product->price;



 

							   $product_type = $woocommerce_product->product_type;

						       $price = $woocommerce_product->regular_price;



								$sale_price = $woocommerce_product->sale_price;





								$sku = $woocommerce_product->sku;

								

								if ( empty ( $price )  && !empty($org_price))

									$price	=	$org_price;

									

								if (trim($price) === '' )

									$price	= -1;



								$price = number_format ( $price, 2, '.', '' );



								$purchase_link = get_permalink($post->ID);

								

								$product_cats = wp_get_post_terms( $post->ID, 'product_cat' );

								

								$descpMain = apply_filters ('the_content', get_the_content());

								$descpMain = self::cut_sense($descpMain, 10000); 

								

								$descpShort = get_post_field( post_excerpt, $post->ID );

								$descpShort = self::cut_sense($descpShort, 10000); 					

				

								echo "    <item>\n\r";

								echo "      <title><![CDATA[".get_the_title($post->ID)."]]></title>\n\r";

								echo "      <link><![CDATA[".$purchase_link."]]></link>\n\r";

								

								echo "      <description><![CDATA[".$descpMain."]]></description>\n\r";

								echo" <description_short><![CDATA[".$descpShort."]]></description_short>\n\r";

								

								$image_link = $this->get_the_post_thumbnail_src ( $post->ID, 'shop_large' );

								

								echo "      <image><![CDATA[".$image_link."]]></image>\n\r";

								

								

								if ( $product_cats && ! is_wp_error ( $product_cats ) ){

									$single_cat = array_shift( $product_cats );

									echo "      <category><![CDATA[".$single_cat->name."]]></category>\n\r";

								}

								

								echo "      <product_type><![CDATA[".$product_type."]]></product_type>\n\r";

								echo "      <price_exclude_tax><![CDATA[".$price_exclude_tax."]]></price_exclude_tax>\n\r";

								echo "      <price><![CDATA[".$price."]]></price>\n\r";

								echo "      <price_html><![CDATA[".$woocommerce_product->get_price_html()."]]></price_html>\n\r";

								echo "      <sale_price><![CDATA[".$sale_price."]]></sale_price>\n\r";

								echo "      <sku><![CDATA[".$sku."]]></sku>\n\r";

								echo "      <currency><![CDATA[".$currency."]]></currency>\n\r";

								

								echo "    </item>\n\r";

							}

							

							echo "  </channel>\n\r";

							echo "</rss>";



							exit();

						break;

					}

				

				}

			}		

		}

		

		public function fs_ajax_fscheck_settings(){

			

			$email	=	get_option('fshop_admin_email');

			if(isset($_POST['admin_email']))

				$email	=	sanitize_email($_POST['admin_email']);

				

			$param['email_id']		=	$email;

			$param["app"] 			=	'fs';

			$param["action"] 		=	"verifyAccount"; 

			

			

			$res = self::_curlResp($param);

			

			if($res['error'] == 1){

				$res['gr_reg']	=	2;

			}else if($res['is_shop'] == 1 && $res['is_valid'] == 1){

			

				$res['gr_reg']	=	0;

				update_option( 'fshop_apps_id', $res['id_apps']);

				update_option( 'fshop_apps_appid', $res['id_site']);

				update_option( 'fshop_apps_payload', $res['pay_load']);

				update_option( 'fshop_admin_email', $param['email_id']);

				update_option( 'fshop_apps_register', 1 );

				$res['login_url']	=	self::$_login_url.'autologin?id_apps='.$res['id_apps'].'&id_site='.$res['id_site'].'&admin_email='.$param['email_id'].'&payload='.$res['pay_load'].'&w_rss='.urlencode(home_url("/index.php?fsawoo=woo_fshop_rss")).'&w_api='.urlencode(home_url("/index.php?fsawoo=woo_fshop_api")).'&w_plg=woo_shop';

				

			}

							

			die(json_encode($res));

		}

		

		public function fs_ajax_fscreate_account(){

			self::callAcctRegister($_POST);

		}

		

		protected static function _curlResp($param)

		{

			$url	=	self::$_curl_url;

			$ch = curl_init();

			curl_setopt($ch,CURLOPT_URL,$url);

			curl_setopt($ch,CURLOPT_HEADER,0);

			curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);

			curl_setopt($ch, CURLOPT_POSTFIELDS, $param); 

			$response = curl_exec($ch);

			curl_close($ch);



			

			return  json_decode($response, true);

		}

		

		protected static function _getIPDetails()

        {

            $ip   = $_SERVER['REMOTE_ADDR'];

            

            return json_decode(file_get_contents('http://www.geoplugin.net/json.gp?ip='.$ip),true);

        }

		

		private function callAcctRegister($p){

		

			$ip_info                =   self::_getIPDetails();

			

			$params["action"] 		= "createaccount"; 

			$params["firstname"] 	= $p['grconnect_reg_firstname'];

			$params["lastname"] 	= $p['grconnect_reg_lastname'];

			$params["companyname"]	= get_bloginfo('name');

			$params["email"]		= sanitize_email($p['grconnect_reg_email']);

			

			$params['address1']     =   '***'; //Dummy

            $params['city']         =   empty($ip_info['city']) ? '***' : $ip_info['city'];

            $params['state']        =   empty($ip_info['region_name']) ? '***' : $ip_info['region_name'];

            $params['postcode']     =   '1'; //Dummy

            $params['country'] 		= empty($ip_info["geoplugin_countryCode"]) ? 'US' : $ip_info["geoplugin_countryCode"];

			

			$params["currency"] 	= ($params["country"] === 'AU')? 3:1;

			$params['phonenumber']	= '1234567890';//Dummy

			$params["notes"] = 'Wordpress Fshop';

			$params["app"] = 'fs';

		

			$resArr	=	self::_curlResp($params);

			

			if(trim($resArr['result'])	==	'success'){

				

				$param				=	array();

				$param['id_site']	=	$resArr['service_id'];

				$param['email']		=	$params["email"];

				self::callGrConnectRegisterApi($param,$p);

			}else{

				$resArr['error']	=	1;

				die(json_encode($resArr));

			}

			

		}

		

		private function callGrConnectRegisterApi($params,$p)

		{

			$param['email_id']		=	$params['email'];

			$param["app"] 			=	'fs';

			$param["action"] 		=	"verifyAccount";

			

			$res = self::_curlResp($param);

			

			if($res['error']	==	0){

				update_option( 'fshop_apps_id', $res['id_apps']);

				update_option( 'fshop_apps_appid', $params['id_site']);

				update_option( 'fshop_apps_payload', $res['pay_load']);

				update_option( 'fshop_admin_email', $params['email']);

				update_option( 'fshop_apps_register', 1 );

								

				$admin_email	=	$params['email'];

				$payload		=	$res['pay_load'];

					

				$res['login_url']	=	self::$_login_url.'autologin?id_apps='.$res['id_apps'].'&id_site='.$params['id_site'].'&admin_email='.$admin_email.'&payload='.$payload.'&w_rss='.urlencode(home_url("/index.php?fsawoo=woo_fshop_rss")).'&w_api='.urlencode(home_url("/index.php?fsawoo=woo_fshop_api")).'&w_plg=woo_shop';

				$response	=	json_encode($res);	

			}

			die($response);

		}	



    } // END class

} // END if(!class_exists())





if(class_exists('Fshop_appsmav'))

{

    // Installation and uninstallation hooks

    register_activation_hook(__FILE__, array('fshop_appsmav', 'activate'));

    register_deactivation_hook(__FILE__, array('fshop_appsmav', 'deactivate'));



    // instantiate the plugin class

    $fshop_appsmav = new Fshop_appsmav();

	

	// Add the settings link to the plugins page

    function plugin_fshopappsmav_settings_link($links)

    { 

        $settings_link = '<a href="options-general.php?page=fshopappsmav">Settings</a>'; 

        array_unshift($links, $settings_link); 

        return $links; 

    }



    $plugin = plugin_basename(__FILE__); 

    add_filter("plugin_action_links_$plugin", 'plugin_fshopappsmav_settings_link');

	add_shortcode('fshop-appsmav-show', array( 'fshop_appsmav', 'fshop_appsmav_show_func' ) );

}