"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const moment_1 = __importDefault(require("moment"));
function formatMS(ms, d, allowMicros = false, allowNanos = true) {
    if (ms === 0 || ms === null)
        return "0";
    const bounds = [
        moment_1.default.duration(1, "hour").asMilliseconds(),
        moment_1.default.duration(1, "minute").asMilliseconds(),
        moment_1.default.duration(1, "second").asMilliseconds(),
        1,
        0.001,
        0.000001
    ];
    const units = ["hr", "min", "s", "ms", "μs", "ns"];
    const makeSmallNumbersNice = (f) => {
        if (f >= 100)
            return f.toFixed(0);
        if (f >= 10)
            return f.toFixed(1);
        if (f === 0)
            return "0";
        return f.toFixed(2);
    };
    const bound = bounds.find(b => b <= ms) || bounds[bounds.length - 1];
    const boundIndex = bounds.indexOf(bound);
    const unit = boundIndex >= 0 ? units[boundIndex] : "";
    if ((unit === "μs" || unit === "ns") && !allowMicros) {
        return "< 1ms";
    }
    if (unit === "ns" && !allowNanos) {
        return "< 1µs";
    }
    const value = typeof d !== "undefined"
        ? (ms / bound).toFixed(d)
        : makeSmallNumbersNice(ms / bound);
    if ((value === "1000" || value === "1000.0") && boundIndex >= 1) {
        return `1${units[boundIndex - 1]}`;
    }
    return `${value}${unit}`;
}
exports.formatMS = formatMS;
//# sourceMappingURL=format.js.map