"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.requiresFieldsMissingOnBase = void 0;
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.requiresFieldsMissingOnBase = ({ schema, }) => {
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        for (const [fieldName, field] of Object.entries(namedType.getFields())) {
            const fieldFederationMetadata = utils_1.getFederationMetadata(field);
            const serviceName = fieldFederationMetadata === null || fieldFederationMetadata === void 0 ? void 0 : fieldFederationMetadata.serviceName;
            if (!serviceName)
                continue;
            if (fieldFederationMetadata === null || fieldFederationMetadata === void 0 ? void 0 : fieldFederationMetadata.requires) {
                const selections = fieldFederationMetadata.requires;
                for (const selection of selections) {
                    const matchingFieldOnType = namedType.getFields()[selection.name.value];
                    const typeFederationMetadata = utils_1.getFederationMetadata(matchingFieldOnType);
                    if (typeFederationMetadata === null || typeFederationMetadata === void 0 ? void 0 : typeFederationMetadata.serviceName) {
                        errors.push(utils_1.errorWithCode('REQUIRES_FIELDS_MISSING_ON_BASE', utils_1.logServiceAndType(serviceName, typeName, fieldName) +
                            `requires the field \`${selection.name.value}\` to be @external. @external fields must exist on the base type, not an extension.`));
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=requiresFieldsMissingOnBase.js.map