"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _child_process = _interopRequireDefault(require("child_process"));

var _git_log_format_markers = require("./constants/git_log_format_markers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const gitLogFormatString = `${_git_log_format_markers.gitLogCommitMarker}%n%H%n%an%n%ae%n%aD%n${_git_log_format_markers.gitLogMessageMarker}%n%B%n${_git_log_format_markers.gitLogFileMarker}`;
/*
  Returns a stream of git log data from a git repository
*/

const gitLogStream = (pathToRepo, options = {}) => {
  const sinceCommit = options.sinceCommit ? `${options.sinceCommit}..HEAD` : '';
  const gitParams = ['log', `--pretty=format:${gitLogFormatString}`, '--name-status', sinceCommit, '--', './*', ':!node_modules'].filter(elt => elt !== '');

  const gitProcess = _child_process.default.spawn('git', gitParams, {
    cwd: pathToRepo
  });

  const errorHandlers = [];
  gitProcess.on('error', e => errorHandlers.forEach(handler => handler(e)));
  return {
    stream: gitProcess.stdout,
    addErrorHandler: fn => errorHandlers.push(fn)
  };
};

var _default = gitLogStream;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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