import { GraphQLSchema, GraphQLCompositeType, GraphQLField, FieldNode, ASTNode, NameNode, SelectionSetNode, DirectiveDefinitionNode, FragmentDefinitionNode, InlineFragmentNode } from "graphql";
import { ExecutionContext } from "graphql/execution/execute";
export declare function isNode(maybeNode: any): maybeNode is ASTNode;
export declare type NamedNode = ASTNode & {
    name: NameNode;
};
export declare function isNamedNode(node: ASTNode): node is NamedNode;
export declare function isDirectiveDefinitionNode(node: ASTNode): node is DirectiveDefinitionNode;
export declare function highlightNodeForNode(node: ASTNode): ASTNode;
export declare function getFieldDef(schema: GraphQLSchema, parentType: GraphQLCompositeType, fieldAST: FieldNode): GraphQLField<any, any> | undefined;
export declare function removeDirectives<AST extends ASTNode>(ast: AST, directiveNames: string[]): AST;
export declare function removeDirectiveAnnotatedFields<AST extends ASTNode>(ast: AST, directiveNames: string[]): AST;
export declare function withTypenameFieldAddedWhereNeeded(ast: ASTNode): any;
export declare function simpleCollectFields(context: ExecutionContext, selectionSet: SelectionSetNode, fields: Record<string, FieldNode[]>, visitedFragmentNames: Record<string, boolean>): Record<string, FieldNode[]>;
export declare function hasClientDirective(node: FieldNode | InlineFragmentNode | FragmentDefinitionNode): boolean | undefined;
export interface ClientSchemaInfo {
    localFields?: string[];
}
declare module "graphql/type/definition" {
    interface GraphQLScalarType {
        clientSchema?: ClientSchemaInfo;
    }
    interface GraphQLObjectType {
        clientSchema?: ClientSchemaInfo;
    }
    interface GraphQLInterfaceType {
        clientSchema?: ClientSchemaInfo;
    }
    interface GraphQLUnionType {
        clientSchema?: ClientSchemaInfo;
    }
    interface GraphQLEnumType {
        clientSchema?: ClientSchemaInfo;
    }
}
//# sourceMappingURL=graphql.d.ts.map